import os

# List of seeds
seeds = [42, 123, 256]  # Example seed list
base_filename = "train"
template_file = "train.sh"

# Read the template file
with open(template_file, 'r') as file:
    template_content = file.read()

# Generate and run each modified script
for counter, seed in enumerate(seeds):
    # Modify the seed value in the template content
    modified_content = template_content.replace("--seed 0", f"--seed {seed}")

    # Create a new filename
    new_filename = f"{base_filename}_{counter}.sh"

    # Write the modified content to the new file
    with open(new_filename, 'w') as file:
        file.write(modified_content)

    # Run the new script with sbatch
    os.system(f"sbatch {new_filename}")
